<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fmp="http://www.filemaker.com/fmpxmlresult" exclude-result-prefixes="fmp">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<!--
ファイル: complex_table.xsl

FMPXMLRESULT文法に基づいてエクスポートされたデータをHTMLテーブルに変換します。
変数によってヘッダと偶数／奇数行の色を設定することができます。

===============================================================

Copyright © 2002 FileMaker, Inc.
All rights reserved.

ソースおよびバイナリ形式での再頒布および使用は、変更のあるなしに拘
わらず、下記の条件が満たされる場合にのみ許可されます。

* ソースコードの再頒布にては、上記の著作権表示、本条件書および下記
  の否認文を明記し保持しなければなりません。

* バイナリ形式での再頒布にては、上記の著作権表示、本条件書および下
  記の否認文を、頒布と共に提供されるドキュメンテーションまたはその
  他の資料において複製しなければなりません。

* FileMaker, Inc. の名称や著作者の名称は、書面による特定の事前許可
  なしに、本ソフトウェアから派生する製品を推奨あるいは促進するため
  に使用してはなりません。

本ソフトウェアは著作権所有者および著作者によって「現状のまま」の状
態で提供され、明示または黙示の保証は商品性および特定目的への適合性
なども含め一切否認されます。著作権所有者あるいは著作者は、本ソフト
ウェアの任意の使用により発生する如何なる直接的損害、間接的損害、付
随的損害、特別損害、懲罰的損害あるいは派生的損害（代用品またはサー
ビスの調達、使用の損失、データの損失、または利益の損失、あるいは事
業の中断による損失なども含む損害）に対しても、因果関係を問わず、契
約の有無、無過失責任の有無、不法行為（不注意による事故その他を含む）
の有無を問わず、一切責任を負いません。損害発生の可能性についてたと
え知らされていたとしても同様とします。

    
===============================================================
-->
	<!--

複数のテンプレートと、より洗練された選択ステートメントを使用して
HTMLテーブルを簡単に作成することができる、少し複雑なスタイルシートです。
-->
	<xsl:template match="fmp:FMPXMLRESULT">
		<html>
			<head>
				<title>
					<xsl:value-of select="$dbName"/>
				</title>
			</head>
			<body>
				<table border="0" cellPadding="3" cellSpacing="1">
					<xsl:call-template name="header"/>
					<!--
次のブロックではこのように色の選択をします。
					
MainOne | ColorOne
MainTwo | ColorTwo
MainOne | ColorOne
MainTwo | ColorTwo
                                  
 position() mod 2, を使って偶数行か奇数行か判断します。
-->
					<xsl:for-each select="fmp:RESULTSET/fmp:ROW">
						<xsl:variable name="id-background-color">
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:value-of select="$mainOne"/>
								</xsl:when>
								<xsl:when test="position() mod 2 = 0">
									<xsl:value-of select="$mainTwo"/>
								</xsl:when>
							</xsl:choose>
						</xsl:variable>
						<xsl:variable name="data-background-color">
							<xsl:choose>
								<xsl:when test="position() mod 2 = 1">
									<xsl:value-of select="$colorOne"/>
								</xsl:when>
								<xsl:when test="position() mod 2 = 0">
									<xsl:value-of select="$colorTwo"/>
								</xsl:when>
							</xsl:choose>
						</xsl:variable>
						<tr>
							<xsl:for-each select="fmp:COL">
								<xsl:variable name="background-color">
									<xsl:choose>
										<xsl:when test="position() = 1">
											<xsl:value-of select="$id-background-color"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$data-background-color"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								<td bgcolor="{$background-color}">
									<xsl:value-of select="fmp:DATA"/>
								</td>
							</xsl:for-each>
						</tr>
					</xsl:for-each>
					<xsl:call-template name="footer"/>
				</table>
			</body>
		</html>
	</xsl:template>
	<!--
テンプレート：ヘッダ
	        
HTMLテーブルのタイトル部分を作成します。
	        
データベース名とレコード数がフィールド名の上部に表示されます。
フィールド名は「headerColor」で指定した背景色のセルに、
「headerFontColor」で指定した色で表示されます。
	-->
	<xsl:template name="header">
		<tr>
			<td align="middle">
				<xsl:attribute name="bgColor"><xsl:value-of select="$headerColor"/></xsl:attribute>
				<xsl:attribute name="colspan"><xsl:call-template name="numfields"/></xsl:attribute>
				<font size="+1">
					<xsl:attribute name="color"><xsl:value-of select="$headerFontColor"/></xsl:attribute>
					<xsl:text>データベース: </xsl:text>
					<xsl:value-of select="fmp:DATABASE/@NAME"/>
				</font>
			</td>
		</tr>
		<tr>
			<td align="middle">
				<xsl:attribute name="bgColor"><xsl:value-of select="$headerColor"/></xsl:attribute>
				<xsl:attribute name="colspan"><xsl:call-template name="numfields"/></xsl:attribute>
				<font color="#ffffff" size="+1">
					<xsl:text>レコード数: </xsl:text>
					<xsl:value-of select="fmp:DATABASE/@RECORDS"/>
				</font>
			</td>
		</tr>
		<tr>
			<xsl:for-each select="fmp:METADATA/fmp:FIELD">
				<td align="middle">
					<xsl:attribute name="bgColor"><xsl:value-of select="$headerColor"/></xsl:attribute>
					<font size="+1">
						<xsl:attribute name="color"><xsl:value-of select="$headerFontColor"/></xsl:attribute>
						<xsl:value-of select="@NAME"/>
					</font>
				</td>
			</xsl:for-each>
		</tr>
	</xsl:template>
	<!--
テンプレート：フッタ

HTMLテーブルのフッタ部分を「footerColor」で指定した背景色のセルで作成します。
	        
XMLファイル作成に使用されたファイルメーカーProのバージョンがビルドの日付と一緒に表示されます。
	-->
	<xsl:template name="footer">
		<tr>
			<td align="middle">
				<xsl:attribute name="bgColor"><xsl:value-of select="$footerColor"/></xsl:attribute>
				<xsl:attribute name="colspan"><xsl:call-template name="numfields"/></xsl:attribute>
				<font color="#ffffff" size="+1">
					<xsl:text>FileMaker Pro Version: </xsl:text>
					<xsl:value-of select="fmp:PRODUCT/@VERSION"/>
				</font>
			</td>
		</tr>
		<tr>
			<td align="middle">
				<xsl:attribute name="bgColor"><xsl:value-of select="$footerColor"/></xsl:attribute>
				<xsl:attribute name="colspan"><xsl:call-template name="numfields"/></xsl:attribute>
				<font size="+1">
					<xsl:attribute name="color"><xsl:value-of select="$headerFontColor"/></xsl:attribute>
					<xsl:text>Build: </xsl:text>
					<xsl:value-of select="fmp:PRODUCT/@BUILD"/>
				</font>
			</td>
		</tr>
	</xsl:template>
	<!--
テンプレート: 数字フィールド（numfields）

METADATAエレメント内の生徒数をチェックする単純なユーティリティテンプレートです。
データベース内のフィールド数を返します。テーブル作成時に便利です。
-->
	<xsl:template name="numfields" match="fmp:METADATA">
		<xsl:value-of select="count(fmp:METADATA/child::*)"/>
	</xsl:template>
	<xsl:variable name="dbName">
		<xsl:value-of select="fmp:FMPXMLRESULT/fmp:DATABASE/@NAME"/>
	</xsl:variable>
	<!--
テーブルは下記のようになります。

         
HeaderColor
MainOne | ColorOne
MainTwo | ColorTwo
MainOne | ColorOne
MainTwo | ColorTwo
FooterColor
      
下記の変数の値を変更することによって、XSLテンプレートを編集しなくても、
結果HTMLテーブルの表示を変更することができます。
	-->
	<xsl:variable name="mainOne">
		<xsl:text>#9bb0d4</xsl:text>
	</xsl:variable>
	<xsl:variable name="mainTwo">
		<xsl:text>#7f95d4</xsl:text>
	</xsl:variable>
	<xsl:variable name="colorOne">
		<xsl:text>#bcd0f0</xsl:text>
	</xsl:variable>
	<xsl:variable name="colorTwo">
		<xsl:text>#9cb0f0</xsl:text>
	</xsl:variable>
	<xsl:variable name="headerColor">
		<xsl:text>#000000</xsl:text>
	</xsl:variable>
	<xsl:variable name="footerColor">
		<xsl:text>#000000</xsl:text>
	</xsl:variable>
	<xsl:variable name="headerFontColor">
		<xsl:text>#ffffff</xsl:text>
	</xsl:variable>
</xsl:stylesheet>
