<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fmp="http://www.filemaker.com/fmpxmlresult">
	<xsl:output method="text" version="1.0" encoding="UTF-8" indent="no"/>
	<!--
ファイル: custom_delim.xsl

FMPXMLRESULT文法に基づいてエクスポートされたデータを、特定のフィールド区切り文字と
レコード区切り文字を使用したテキストファイルに変換します。

フィールド区切り文字とレコード区切り文字を選択するときに、ファイルメーカーProがインポート
することのできない文字も選択可能であることに注意してください。
インポートできない区切り文字の例:

データベースのデータ
=============
White     Johnson  Red       33
Green     Mark     Red      100 
Blue      Sam      Blue     201 
Yellow    Susan    Green    839 
Straight  Wendy    Orange    22

出力結果
======
White*Johnson*Red*33
Green*Mark*Red*100 
Blue*Sam*Blue*201 
Yellow*Susan*Green*839 
Straight*Wendy*Orange*22
 
===============================================================

Copyright © 2002 FileMaker, Inc.
All rights reserved.

ソースおよびバイナリ形式での再頒布および使用は、変更のあるなしに拘
わらず、下記の条件が満たされる場合にのみ許可されます。

* ソースコードの再頒布にては、上記の著作権表示、本条件書および下記
  の否認文を明記し保持しなければなりません。

* バイナリ形式での再頒布にては、上記の著作権表示、本条件書および下
  記の否認文を、頒布と共に提供されるドキュメンテーションまたはその
  他の資料において複製しなければなりません。

* FileMaker, Inc. の名称や著作者の名称は、書面による特定の事前許可
  なしに、本ソフトウェアから派生する製品を推奨あるいは促進するため
  に使用してはなりません。

本ソフトウェアは著作権所有者および著作者によって「現状のまま」の状
態で提供され、明示または黙示の保証は商品性および特定目的への適合性
なども含め一切否認されます。著作権所有者あるいは著作者は、本ソフト
ウェアの任意の使用により発生する如何なる直接的損害、間接的損害、付
随的損害、特別損害、懲罰的損害あるいは派生的損害（代用品またはサー
ビスの調達、使用の損失、データの損失、または利益の損失、あるいは事
業の中断による損失なども含む損害）に対しても、因果関係を問わず、契
約の有無、無過失責任の有無、不法行為（不注意による事故その他を含む）
の有無を問わず、一切責任を負いません。損害発生の可能性についてたと
え知らされていたとしても同様とします。

    
===============================================================
-->
	<xsl:template match="fmp:FMPXMLRESULT">
		<xsl:for-each select="fmp:RESULTSET/fmp:ROW">
			<xsl:for-each select="fmp:COL">
				<xsl:choose>
					<xsl:when test="position()=last()">
						<xsl:value-of select="fmp:DATA"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="fmp:DATA"/>
						<xsl:value-of select="$delimiter"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			<xsl:value-of select="$newrecord"/>
		</xsl:for-each>
	</xsl:template>
	<!--  変数「delimiter」にはエクスポートされたデータのフィールド間にある区切り文字が格納されます。
	        
  "xsl:text" タグの間にある"*"を変更してカスタマイズを行います。
	-->
	<xsl:variable name="delimiter">
		<xsl:text>*</xsl:text>
	</xsl:variable>
	<!--  
変数「 newline」には出力データの中でレコードの終わりを示す文字 が格納されます。
デフォルトではレコードの区切り文字はキャリッジリターン（CR）です。xsl:textタグの間にその他の文字を指定して、別の区切り文字を設定することもできます。        

	-->
<xsl:variable name="newrecord">
<xsl:text>
</xsl:text>
</xsl:variable>
</xsl:stylesheet>
