<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fmp="http://www.filemaker.com/fmpxmlresult">
	<xsl:output method="text"  version="1.0" encoding="UTF-8" indent="no"/>
<!--
ファイル： fixed_width.xsl

FMPXMLRESULT文法に基づいてエクスポートされたデータを連続した固定長テキストデータに
変換します。指定された長さよりも短いデータは定義された文字を指定文字数まで挿入します。
デフォルトでは、スペースを使用しますが、これは下記の「padding_character」変数を使用して変更する
ことができます。
どのフィールドのデータも「columnwidth」変数で定義された文字数を超えた分は最終出力結果
で切り捨てられます。
　出力されたデータフィールド間には区切り文字がないことに注意して下さい。データはレコード毎
　に連続しています。
　例えば、このようなデータベースでは、

フィールド A           フィールドB     フィールドC
Data in field A   One         Another
The               Next        Again
11                32          FileMaker

「columnwidth」変数で「４」を指定してエクスポートすると、下のようになります。


============
DataOne Anot
The NextAgai
11  32  File

「columnwidth」変数の値を変更して、列幅を調整してください。

substring(引数,開始,長さ)関数はゼロベースではなく１ベースであることに
注意して下さい。

===============================================================

Copyright © 2002 FileMaker, Inc.
All rights reserved.

ソースおよびバイナリ形式での再頒布および使用は、変更のあるなしに拘
わらず、下記の条件が満たされる場合にのみ許可されます。

* ソースコードの再頒布にては、上記の著作権表示、本条件書および下記
  の否認文を明記し保持しなければなりません。

* バイナリ形式での再頒布にては、上記の著作権表示、本条件書および下
  記の否認文を、頒布と共に提供されるドキュメンテーションまたはその
  他の資料において複製しなければなりません。

* FileMaker, Inc. の名称や著作者の名称は、書面による特定の事前許可
  なしに、本ソフトウェアから派生する製品を推奨あるいは促進するため
  に使用してはなりません。

本ソフトウェアは著作権所有者および著作者によって「現状のまま」の状
態で提供され、明示または黙示の保証は商品性および特定目的への適合性
なども含め一切否認されます。著作権所有者あるいは著作者は、本ソフト
ウェアの任意の使用により発生する如何なる直接的損害、間接的損害、付
随的損害、特別損害、懲罰的損害あるいは派生的損害（代用品またはサー
ビスの調達、使用の損失、データの損失、または利益の損失、あるいは事
業の中断による損失なども含む損害）に対しても、因果関係を問わず、契
約の有無、無過失責任の有無、不法行為（不注意による事故その他を含む）
の有無を問わず、一切責任を負いません。損害発生の可能性についてたと
え知らされていたとしても同様とします。

    
===============================================================
-->
	<xsl:template match="fmp:FMPXMLRESULT">
		<xsl:for-each select="fmp:RESULTSET/fmp:ROW">
			<xsl:for-each select="fmp:COL">
				<xsl:choose>
					<xsl:when test="string-length(fmp:DATA) &lt; $columnwidth">
						<xsl:value-of select="fmp:DATA"/>
						<xsl:call-template name="pad_output">
							<xsl:with-param name="numspaces" select="$columnwidth - string-length(fmp:DATA)"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="substring(fmp:DATA,1,$columnwidth)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			<xsl:value-of select="$newline"/>
		</xsl:for-each>
	</xsl:template>
	
<!--
テンプレート: 挿入文字追加
	
出力用の挿入文字の数を引数とする帰納的関数
-->
	<xsl:template name="pad_output">
		<xsl:param name="numspaces" select="0"/>
		<xsl:if test="$numspaces &gt; 0">
			<xsl:value-of select="$padding_character"/>
			<xsl:call-template name="pad_output">
				<xsl:with-param name="numspaces" select="$numspaces - 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
<!--この変数はそれぞれのフィールドの列幅を制御します。

-->
	<xsl:variable name="columnwidth">
		<xsl:text>17</xsl:text>
	</xsl:variable>
<!--
デフォルトでは「columnwidth」よりも短いフィールドにスペースを挿入します。
スペースはどんな文字にも変更することができます。

-->
	<xsl:variable name="padding_character">
		<xsl:text> </xsl:text>
	</xsl:variable>
<!--
「text」アウトプットメソッドは下記のxsl:textタグの間にキャリッジリターン（CR）を
挿入します。挿入する文字は変更可能で，出力結果を自動読み込みする場合に特に便利です。
-->	
<xsl:variable name="newline">
<xsl:text>
</xsl:text>
</xsl:variable>
</xsl:stylesheet>
