<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fmp="http://www.filemaker.com/fmpxmlresult" exclude-result-prefixes="fmp">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<!--

ファイル: simple_table.xsl
FMPXMLRESULT文法に基づいて書き出されたデータをHTMLテーブルに変換します。

===============================================================

Copyright © 2002 FileMaker, Inc.
All rights reserved.

ソースおよびバイナリ形式での再頒布および使用は、変更のあるなしに拘
わらず、下記の条件が満たされる場合にのみ許可されます。

* ソースコードの再頒布にては、上記の著作権表示、本条件書および下記
  の否認文を明記し保持しなければなりません。

* バイナリ形式での再頒布にては、上記の著作権表示、本条件書および下
  記の否認文を、頒布と共に提供されるドキュメンテーションまたはその
  他の資料において複製しなければなりません。

* FileMaker, Inc. の名称や著作者の名称は、書面による特定の事前許可
  なしに、本ソフトウェアから派生する製品を推奨あるいは促進するため
  に使用してはなりません。

本ソフトウェアは著作権所有者および著作者によって「現状のまま」の状
態で提供され、明示または黙示の保証は商品性および特定目的への適合性
なども含め一切否認されます。著作権所有者あるいは著作者は、本ソフト
ウェアの任意の使用により発生する如何なる直接的損害、間接的損害、付
随的損害、特別損害、懲罰的損害あるいは派生的損害（代用品またはサー
ビスの調達、使用の損失、データの損失、または利益の損失、あるいは事
業の中断による損失なども含む損害）に対しても、因果関係を問わず、契
約の有無、無過失責任の有無、不法行為（不注意による事故その他を含む）
の有無を問わず、一切責任を負いません。損害発生の可能性についてたと
え知らされていたとしても同様とします。

    
===============================================================
-->
<!--
Template: match="fmp:FMPXMLRESULT"
テーブル作成のためのメインドライバです。最初にヘッダテンプレートを呼び出し、
「RESULTSET」ノードセットを繰り返してテーブルの行を作成します。
-->
	<xsl:template match="fmp:FMPXMLRESULT">
		<html>
			<head>
				
			</head>
			<body>
				<table border="1" cellPadding="1" cellSpacing="1">
					<xsl:call-template name="header"/>
					<xsl:for-each select="fmp:RESULTSET/fmp:ROW">
						<tr>
							<xsl:for-each select="fmp:COL">
								<td>
									<xsl:value-of select="fmp:DATA"/>
								</td>
							</xsl:for-each>
						</tr>
					</xsl:for-each>
				</table>
			</body>
		</html>
	</xsl:template>
<!--
テンプレート: ヘッダ

HTMLテーブルのヘッダを作成します。データベース名とレコード数がフィールド名の上
に表示されます。

-->
	<xsl:template name="header">
		<tr>
			<td align="middle">
				<xsl:attribute name="colspan"><xsl:call-template name="numfields"/></xsl:attribute>
				<xsl:text>データベース名: </xsl:text>
				<xsl:value-of select="fmp:DATABASE/@NAME"/>
			</td>
		</tr>
		<tr>
			<td align="middle">
				<xsl:attribute name="colspan"><xsl:call-template name="numfields"/></xsl:attribute>
				<xsl:text>レコード数: </xsl:text>
				<xsl:value-of select="fmp:DATABASE/@RECORDS"/>
			</td>
		</tr>
		<tr>
			<xsl:for-each select="fmp:METADATA/fmp:FIELD">
				<td align="middle">
					<xsl:value-of select="@NAME"/>
				</td>
			</xsl:for-each>
		</tr>
	</xsl:template>
<!--
テンプレート: フィールド数
METADATAエレメントの中に何人の生徒情報が存在するかチェックするためのユーティリティで、
データベース内のフィールド数を返します。テーブル作成時に便利です。
-->
	<xsl:template name="numfields" match="fmp:METADATA">
		<xsl:value-of select="count(fmp:METADATA/child::*)"/>
	</xsl:template>
</xsl:stylesheet>
