<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<!--

File: msdso_elem.xslt



エレメントベースのMSDSO文法に基づいたデータをFMPXMLRESULT文法に変換し、ファイルメーカーでインポートできるようにします。

      
===============================================================

Copyright © 2002 FileMaker, Inc.
All rights reserved.

ソースおよびバイナリ形式での再頒布および使用は、変更のあるなしに拘
わらず、下記の条件が満たされる場合にのみ許可されます。

* ソースコードの再頒布にては、上記の著作権表示、本条件書および下記
  の否認文を明記し保持しなければなりません。

* バイナリ形式での再頒布にては、上記の著作権表示、本条件書および下
  記の否認文を、頒布と共に提供されるドキュメンテーションまたはその
  他の資料において複製しなければなりません。

* FileMaker, Inc. の名称や著作者の名称は、書面による特定の事前許可
  なしに、本ソフトウェアから派生する製品を推奨あるいは促進するため
  に使用してはなりません。

本ソフトウェアは著作権所有者および著作者によって「現状のまま」の状
態で提供され、明示または黙示の保証は商品性および特定目的への適合性
なども含め一切否認されます。著作権所有者あるいは著作者は、本ソフト
ウェアの任意の使用により発生する如何なる直接的損害、間接的損害、付
随的損害、特別損害、懲罰的損害あるいは派生的損害（代用品またはサー
ビスの調達、使用の損失、データの損失、または利益の損失、あるいは事
業の中断による損失なども含む損害）に対しても、因果関係を問わず、契
約の有無、無過失責任の有無、不法行為（不注意による事故その他を含む）
の有無を問わず、一切責任を負いません。損害発生の可能性についてたと
え知らされていたとしても同様とします。

    
===============================================================

-->

       

	<xsl:template match="/*">

		<FMPXMLRESULT xmlns="http://www.filemaker.com/fmpxmlresult">

			<ERRORCODE>0</ERRORCODE>

			<PRODUCT BUILD="" NAME="" VERSION=""/>

			<DATABASE DATEFORMAT="M/d/yyyy" LAYOUT="" NAME="" RECORDS="{count(/*/*)}" TIMEFORMAT="h:mm:ss a"/>

			<METADATA>

				<xsl:for-each select="/*/*[position()=1]/*">

					<FIELD>

						<xsl:attribute name="EMPTYOK">YES</xsl:attribute>

						<xsl:attribute name="MAXREPEAT">1</xsl:attribute>

						<xsl:attribute name="NAME"><xsl:value-of select="name()"/></xsl:attribute>

						<xsl:attribute name="TYPE">TEXT</xsl:attribute>

					</FIELD>

				</xsl:for-each>

			</METADATA>

			<RESULTSET>

				<xsl:attribute name="FOUND"><xsl:value-of select="count(child::*)"/></xsl:attribute>

				<xsl:for-each select="child::*">

					<ROW>

						<xsl:attribute name="MODID">0</xsl:attribute>

						<xsl:attribute name="RECORDID">0</xsl:attribute>

						<xsl:for-each select="child::*">

							<COL>

								<DATA>

									<xsl:value-of select="."/>

								</DATA>

							</COL>

						</xsl:for-each>

					</ROW>

				</xsl:for-each>

			</RESULTSET>

		</FMPXMLRESULT>

	</xsl:template>

</xsl:stylesheet>

